<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cfg="." xmlns:user="http://bosch.com">
  <!--
BOSCH Security Sytems (Grasbrunn)
Project: Magic.Panel
Author: Maria Lux
Created: 8.4.2016
$Revision: 1.1 $ 
Last locked:   $Date: 2016/09/12 09:43:32GMT $
Last change by $Author: Maria Lux (lux2ot) $
History: 
$Log: XSLT/convert_to_fpa5000.xslt  $
Revision 1.1 2016/09/12 09:43:32GMT Maria Lux (lux2ot) 
Initial revision
Member added to project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/RPSTools/XMLSupport/XMLSupport.pj
-->
  <cfg:Stylesheet mode="TRANSFORM" version="$Revision: 1.1 $"/>
  <xsl:output method="xml" indent="yes"/>
  <!--****************  GENERIC PART iterate thru all nodes and copy elements and attribute ***********************-->
  <!-- copies each node implicitly by match 'node()', the attributes need to be copied explicitly by template @*-->
  <xsl:template match="*">
    <xsl:element name="{name()}">
      <xsl:apply-templates select="node()">
    </xsl:apply-templates>
    </xsl:element>
  <!-- explicitly copy comments -->
      <xsl:apply-templates select="comment()">
    </xsl:apply-templates>
</xsl:template>
  <!-- explicitly copy attributes -->
  <!-- we do not copy attributes anymore (exception panelEncoding). Thus we force the creation of new rpsDisplayNames, which have been wrong in some RPS-versions  -->
  <xsl:template match="@*">
	  <xsl:choose>
			<xsl:when test="name()='rpsDisplayName'">
				  <!-- remove the attribute rpsDisplayname-->
				  <!--xsl:comment>rpsDisplayname removed</xsl:comment-->
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy/>
				  <!--xsl:comment>attribute <xsl:value-of select="name()"/> copied</xsl:comment-->
			</xsl:otherwise>
		</xsl:choose>
  </xsl:template>
  <!-- explicitly copy comments -->
  <xsl:template match="comment()">
    <xsl:copy/>
  </xsl:template>
  
  <!-- explicitly copy attributes of a certain nodeset
  <xsl:template name="CopyAttributesOf">
    <xsl:param name="Element"/>
    <xsl:for-each select="$Element">
      <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
    </xsl:for-each>
  </xsl:template>
-->
  <!-- -->
  <!--***************************************-->
  <!-- -->
  <xsl:template match="HEADER">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="HEADER">
      <xsl:variable name="version" select="dataVersion"/>
	  <xsl:variable name="temp" select="user:SetConfigVersion(string($version))"/>
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name()='dataVersion'">
			<xsl:element name="dataVersion">
				<xsl:value-of select="$version"/>
			</xsl:element>
          </xsl:when>
	<!-- always reset xmlValidation and mismatchConfirmed; there are always changes and the xmlValidation-value is no longer valid -->
          <xsl:when test="name()='xmlValidation'">
			<xsl:element name="xmlValidation">
				<xsl:text>0000</xsl:text>
			</xsl:element>
          </xsl:when>
          <xsl:when test="name()='mismatchConfirmed'">
			<xsl:element name="mismatchConfirmed">
				<xsl:text></xsl:text>
			</xsl:element>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <!--***************************************-->
  <!-- NODE must be copied and updated-->
  <xsl:template match="NODE">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:variable name="temp1" select="user:SetFromBtoC('0')"/><!-- reset the value -->
    <xsl:element name="NODE">
	  <xsl:variable name="hasSpanningTree" select="SPANNING_TREE=true()"/>
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name()='nodeType' and (text()='FPA1100_EN-C' or text()='FPA1200_EN-C')">
          <!-- there could be a remote keypad, too -->
			  <xsl:element name="nodeType">FPA5000-C</xsl:element>
          </xsl:when>
          <xsl:when test="name()='nodeType' and text()='FPA1200_EN'">
          <!-- only for the 1200 there is the B-version; there could be a remote keypad, too -->
			  <xsl:variable name="newversion" select="user:GetConfigVersion()"/>
			  <xsl:choose>
				<xsl:when test="user:IsVersionGreaterOrEqual($newversion,'2.8.0')">
					<xsl:element name="nodeType">FPA5000-C</xsl:element>
					<xsl:variable name="temp2" select="user:SetFromBtoC('1')"/>
				</xsl:when>
				<xsl:otherwise>
					<!-- take the B-version although it is not produced anymore; the operator later has to upgrade explicitly -->
					<xsl:element name="nodeType">FPA5000</xsl:element>
				</xsl:otherwise>
			  </xsl:choose>
          </xsl:when>
		  <xsl:when test="name()='NET_INTERFACES'">
			  <xsl:variable name="fromBtoC" select="user:GetFromBtoC()"/>
			  <xsl:choose>
				  <xsl:when test="$fromBtoC='1'">
					  <xsl:if test="$hasSpanningTree=false()">
						  <!--xsl:call-template name="InsertSPANNING_TREE"/-->
					  </xsl:if>
					  <xsl:element name="NET_INTERFACES">
						  <xsl:for-each select="*">
							<xsl:choose>
							  <xsl:when test="name()='NET_INTERFACE' and type='ETHERNET' and interfaceNbr='1'">
									<xsl:apply-templates select="."/>
									<xsl:call-template name="CreateEthernetInterface">
										<xsl:with-param name="InterfaceNumber" select="'2'"/>
									</xsl:call-template>
							  </xsl:when>
							  <xsl:otherwise>
								<xsl:apply-templates select="."/>
							  </xsl:otherwise>
							</xsl:choose>
						  </xsl:for-each>
					  </xsl:element>
				  </xsl:when>
				  <xsl:otherwise>
					<xsl:apply-templates select="."/>
				  </xsl:otherwise>
			  </xsl:choose>
		  </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <!--***************************************-->
  <!-- -->
  <xsl:template match="ETHERNET">
	<xsl:variable name="fromBtoC" select="user:GetFromBtoC()"/>
	<xsl:element name="ETHERNET">
		<xsl:element name="port"><xsl:value-of select="port"/></xsl:element>
		<xsl:element name="siType"><xsl:value-of select="siType"/></xsl:element>
		<xsl:element name="enabled"><xsl:value-of select="enabled"/></xsl:element>
	</xsl:element>
	<xsl:if test="port='1' and $fromBtoC='1'">
		<xsl:call-template name="CreateEthernetPort">
			<xsl:with-param name="portNumber" select="'2'"/>
		</xsl:call-template>
	</xsl:if>
  </xsl:template>
  <!-- -->
  <!--***************************************-->
  <!-- -->
  <xsl:template name="CreateEthernetPort">
    <xsl:param name="portNumber"/>
	<xsl:element name="ETHERNET">
		<xsl:element name="port">2</xsl:element>
		<xsl:element name="siType">MP_SI_NETWORK_LINE</xsl:element>
		<xsl:element name="enabled">ST_NO</xsl:element>
	</xsl:element>
  </xsl:template>
  <!-- -->
  <!--***************************************-->
  <!-- -->
  <xsl:template name="CreateEthernetInterface">
    <xsl:param name="InterfaceNumber"/>
    <xsl:variable name="newversion" select="user:GetConfigVersion()"/>
    <xsl:element name="NET_INTERFACE">
      <xsl:element name="type">
        <xsl:text>ETHERNET</xsl:text>
      </xsl:element>
      <xsl:element name="interfaceNbr">
        <xsl:value-of select="$InterfaceNumber"/>
      </xsl:element>
      <xsl:element name="connectedToNetlineNbr">0</xsl:element>
      <!-- new in 2.8.2 isUsed -->
      <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.8.2')">
        <xsl:element name="isUsed">ST_NO</xsl:element>
      </xsl:if>
      <xsl:element name="ETHERNET_PARAM">
        <xsl:element name="lineType">
          <xsl:text>CONNECTED_TO_LINK</xsl:text>
        </xsl:element>
        <xsl:element name="speedAndDuplex">
          <xsl:text>Auto</xsl:text>
        </xsl:element>
        <xsl:element name="flowControl">
          <xsl:text>Disabled</xsl:text>
        </xsl:element>
        <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.8.2')">
          <xsl:element name="STP_PathCost">200000</xsl:element>
          <xsl:element name="STP_PortPriority">128</xsl:element>
          <xsl:element name="RSTP_LinkType">AUTO</xsl:element>
        </xsl:if>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <!--***************************************-->
  <!-- -->
  <xsl:template name="InsertSPANNING_TREE">
	  <xsl:element name="SPANNING_TREE">
		<xsl:element name="redundancyMode">OFF</xsl:element>
		<xsl:element name="STP_BridgePriority">32768</xsl:element>
		<xsl:element name="STP_HelloTime">2</xsl:element>
		<xsl:element name="STP_MaxAge">20</xsl:element>
		<xsl:element name="STP_ForwardDelay">15</xsl:element>
	  </xsl:element>
  </xsl:template>
  <!-- -->
  <!--***************************************-->
  <!-- -->
  <xsl:template name="InsertConversionComment">
	  <xsl:param name="structureName"/>
<!-- currently not used	  
	<xsl:comment>
		<xsl:text>updated by template </xsl:text><xsl:value-of select="$structureName"/><xsl:text> </xsl:text>
		<xsl:value-of select="user:GetCurrentDateTime()"/>
		<xsl:text> converted from </xsl:text><xsl:value-of select="$ConvertedFrom"/><xsl:text> to </xsl:text><xsl:value-of select="$newversion"/>
	</xsl:comment>
-->
  </xsl:template>
  <!-- -->
  <!-- -->
  <xsl:template name="InsertConversionCommentWithMode">
	  <xsl:param name="structureName"/>
	  <xsl:param name="myMode"/>
<!-- currently not used	  
	<xsl:comment>
		<xsl:text>updated by template </xsl:text> <xsl:value-of select="$structureName"/><xsl:text> Mode: </xsl:text><xsl:value-of select="$myMode"/><xsl:text> </xsl:text>
		<xsl:value-of select="user:GetCurrentDateTime()"/>
		<xsl:text> converted from </xsl:text><xsl:value-of select="$ConvertedFrom"/><xsl:text> to </xsl:text><xsl:value-of select="$newversion"/>
	</xsl:comment>
-->
  </xsl:template>
  <!-- -->
  <xsl:template name="InsertTrace">
	  <xsl:param name="traceText"/>
<!-- currently not used	  
	<xsl:comment>
		<xsl:text>TRACE: </xsl:text> <xsl:value-of select="$traceText"/>
	</xsl:comment>
-->
  </xsl:template>
  <!-- -->
  <!-- Compare versions strings of form 'major.minor.sub' by script; same function as in create-net.xsl -->
  <msxsl:script language="javascript" implements-prefix="user">
	<![CDATA[
   var fromBtoC = "0";
   function SetFromBtoC(value)
   {
	   fromBtoC = value;
	   return fromBtoC;
   }
   function GetFromBtoC()
   {
	   return fromBtoC;
   }
   var configVersion = "0.0.0";
   function SetConfigVersion(value)
   {
	   configVersion = value;
	   return configVersion;
   }
   function GetConfigVersion()
   {
	   return configVersion;
   }
   function IsVersionGreaterOrEqual(left,right)
   {
      // version strings of the form aa.bb.cc can be compared
      // aa bb cc may only contain 2 digits
      var versionLeft = 0;
      var versionRight = 0;
      var tokenLeft = left.split(".");
      versionLeft = Number(tokenLeft[0]) * 10000;
      versionLeft += Number(tokenLeft[1]) * 100;
      versionLeft += Number(tokenLeft[2]);
      var tokenRight = right.split(".");
      versionRight = Number(tokenRight[0]) * 10000;
      versionRight += Number(tokenRight[1]) * 100;
      versionRight += Number(tokenRight[2]);
      return versionLeft >= versionRight;
   }
]]>
</msxsl:script>
</xsl:stylesheet>
